/* CFU Proving Ground since 2025-02    Copyright(c) 2025 Archlab. Science Tokyo /
/ Released under the MIT license https://opensource.org/licenses/mit           */

#include <stdlib.h>
#include <stdio.h>

#include "st7789.h"
#include "perf.h"
#include "util.h"

#define NUM (1024*100/4) // 100KB
#define LOOPS 100

int comp_int(const void *a, const void *b) {
    int va = *(int*)a;
    int vb = *(int*)b;
    return va - vb;
}


int main () {
    pg_lcd_reset();
    char buf[256];
    int a[NUM];
    int check_sum1 = 0;
    int check_xor1 = 0;
    int error = 0;

    pg_perf_disable();
    pg_perf_reset();
    pg_perf_enable();

    srand(17);
    
    pg_lcd_prints_8x8("Benchmark_sort_v2025-11-06a\n");

    for(int j=1; j<=LOOPS; j++){
        check_sum1 = 0;
        check_xor1 = 0;
        for(int i=0; i<NUM; i++){
            a[i] = rand() & 0xffffff;
            check_sum1 += a[i];
            check_xor1 ^= a[i];
        }

        qsort(a, NUM, sizeof(int), comp_int); /* sorting here */

        int check_sum2 = 0;
        int check_xor2 = 0;
    
        for(int i=0; i<NUM; i++){
            check_sum2 += a[i];
            check_xor2 ^= a[i];
        }
        for(int i=1; i<NUM; i++){
            if (a[i-1] > a[i] ) error = 1;
        }
        if(check_sum1 != check_sum2) error = 1;
        if(check_xor1 != check_xor2) error = 1;
        
        sprintf(buf, "%3d: %08x %08x", j, check_sum2, check_xor2); pg_lcd_prints_8x8(buf);
        if (error==0) pg_lcd_prints_8x8(" -> OK\n");
        else pg_lcd_prints_8x8(" -> NG\n");
        
    }
    
    pg_lcd_prints_8x8("---------- finished ----------\n");
    unsigned long long cycle = pg_perf_cycle();
    unsigned long long insns = pg_perf_insns();
    int insnpk =  insns*1000/cycle;
    sprintf(buf, "cycle      : %15lld\n", cycle); pg_lcd_prints_8x8(buf);
    sprintf(buf, "insn       : %15lld\n", insns); pg_lcd_prints_8x8(buf);
    sprintf(buf, "insn/Kcycle: %15d\n",  insnpk); pg_lcd_prints_8x8(buf);
    pg_lcd_prints_8x8("------------------------------\n");
    
    return 0;
}
