/** BPkit: Branch Prediction Toolkit          Kenji KISE, Tokyo Tech **/
/**********************************************************************/
#include "../../Core/define.h"
#define VER "Two-bit Saturating Counter Ver 1.0.0 (2007-04-10)"

FILE *fp_log;

/**********************************************************************/
#define BC_MAX 3 /* saturating counter maximum value   */
#define BC_MIN 0 /* saturating counter minimum value   */
#define BC_MID 2 /* saturating counter threshold value */

int sc;     /* saturating counter */
/**********************************************************************/
int bp_name(int *reserve)
{
    fprintf(fp_log, "%s\n", VER);
    return 0;
}

/**********************************************************************/
int bp_init(FILE *fp, int n, int *reserve)
{
    fp_log = fp;
    sc = BC_MID;
    return 0;
}

/**********************************************************************/
int bp_finalize(int *reserve)
{
    return 0;
};

/**********************************************************************/
int bp_predict(unsigned int pc, int *reserve, int *pred)
{
    *pred = (sc>=BC_MID) ? 1 : 0;
    return 0;
}

/**********************************************************************/
int bp_regist(unsigned int pc, int taken, int *reserve)
{
    if (taken==1 && sc<BC_MAX) sc++;
    if (taken==0 && sc>BC_MIN) sc--;
    return 0;
}
/**********************************************************************/
