/** BPkit: Branch Prediction Toolkit          Kenji KISE, Tokyo Tech **/
/**********************************************************************/
#include "../../Core/define.h"
#define VER "Bimodal Predictor[8KB] Ver 1.0.0 (2007-04-11)"

/**********************************************************************/
#define BC_MAX 3 /* saturating counter maximum value   */
#define BC_MIN 0 /* saturating counter minimum value   */
#define BC_MID 2 /* saturating counter threshold value */
#define HARDWARE 3 /** 0=1KB, 1=2KB, 2=4KB, 3=8KB, 4=16KB, 5=32KB **/
#define TABLE_SIZE (1 << (13+HARDWARE))

FILE *fp_log;
int *pht;     /* PHT, pattern history table */

/**********************************************************************/
int bp_name(int *reserve)
{
    fprintf(fp_log, "%s\n", VER);
    return 0;
}

/**********************************************************************/
int bp_init(FILE *fp, int n, int *reserve)
{
    int i;
    pht = (int *)malloc(TABLE_SIZE * sizeof(int));
    for (i=0; i<TABLE_SIZE; i++) 
        pht[i] = BC_MID;
    fp_log = fp;
    return 0;
}

/**********************************************************************/
int bp_finalize(int *reserve)
{
    return 0;
};

/**********************************************************************/
int get_index(unsigned int pc)
{
    return ((unsigned int)pc % TABLE_SIZE);
}

/**********************************************************************/
int bp_predict(unsigned int pc, int *reserve, int *pred)
{
    int index = get_index(pc);
    *pred = (pht[index]>=BC_MID) ? 1 : 0;
    return 0;
}

/**********************************************************************/
int bp_regist(unsigned int pc, int taken, int *reserve)
{
    int index = get_index(pc);
    int *sc = &pht[index];
    
    /***** update the PHT *****/
    if (taken==1 && *sc<BC_MAX) (*sc)++;
    if (taken==0 && *sc>BC_MIN) (*sc)--;
    return 0;
}
/**********************************************************************/
