/**********************************************************************
 * SimMips: Simple Computer Simulator of MIPS    Arch Lab. TOKYO TECH *
 **********************************************************************/
#include "define.h"

/**********************************************************************/
typedef int data_t;

typedef struct cache_line {
    data_t valid;
    data_t tag;
    data_t data;
} cline;

static int cache_size;
static cline *buf;
static int cache_hit;
static int cache_miss;

/**********************************************************************/
int cache_init(int size)
{
    cache_hit  = 0;
    cache_miss = 0;
    cache_size = size;
    buf  = (cline *)calloc(cache_size, sizeof(cline));
    return 0;
}

/**********************************************************************/
int cache_finalize()
{
    printf("$$ cache size %5d (KB), hit %8d , miss %8d\n", 
           cache_size*4/1024, cache_hit, cache_miss);
           
    printf("$$ cache hit rate %7.3f\n\n", 
           (double)cache_hit /(double)(cache_hit+ cache_miss)*100.0);
           
    return 0;
}

/**********************************************************************/
int cache_access(int address)
{
    int index  = (address >> 2) % cache_size;
    data_t tag = (address >> 2);

    if(buf[index].valid && buf[index].tag==tag){ /** cache hit **/
        cache_hit ++;
    }
    else{  /** cache miss **/
        cache_miss ++;
        buf[index].valid = 1;
        buf[index].tag   = tag;
        buf[index].data = 0; // dummy data 
    }

    //   printf("address %08x hit %8d , miss %8d\n", 
    //           address, cache_hit, cache_miss);
    return 0;
}
/**********************************************************************/

