/**********************************************************************/
/* MieruPC Project: Sample Version 2009-07-14    Arch Lab. Tokyo Tech */
/**********************************************************************/
#include <stdio.h>
#include <stdlib.h>

#define BUFSIZE (1024*12)

int a[BUFSIZE];

/**********************************************************************/
static unsigned int next = 1;

unsigned int myrand(void) {
    next = next * 1103515245 + 12345;
    return((unsigned)(next/65536) % 32768);
}

/**********************************************************************/
void partition(int p, int q, int *jp, int *ip)
{
    int i, j;
    int s;

    i = p;
    j = q;
    s = a[p];
    while (i <= j) {
        while (a[i] < s)
            ++i;
        while (a[j] > s)
            --j;
        if (i <= j) {
            int temp = a[i];
            a[i] = a[j];
            a[j] = temp;
            ++i;
            j--;
        }
    }
    *jp = j;
    *ip = i;
}

/**********************************************************************/
void quicksort(int p, int q)
{
    int i, j;
    if (p < q) {
        partition(p, q, &j, &i);
        quicksort(p, j);
        quicksort(i, q);
    }
}

/**********************************************************************/
int main(void)
{
    int i;

    for(i=0; i<BUFSIZE; i++) {
        a[i] = myrand(); // & 0xffff;
    }

    printf("--------------------------------------------------\n");
    for(i=0; i<BUFSIZE; i=i+500) {
        printf("before a[%5d] %6d\n", i, a[i]);
    }

    quicksort(0, BUFSIZE-1);

    printf("--------------------------------------------------\n");
    for(i=0; i<BUFSIZE; i=i+500) {
        printf("after  a[%5d] %6d\n", i, a[i]);
    }

    return 0;
}

/**********************************************************************/
